const { app, BrowserWindow, ipcMain, autoUpdater, dialog } = require('electron');
const path = require('path');

let win;

function createWindow() {
    win = new BrowserWindow({
        width: 1080,
        height: 720,
        resizable: false,
        frame: true,
        webPreferences: {
            preload: path.join(__dirname, 'preload.js'),
            contextIsolation: true,
            enableRemoteModule: false,
            nodeIntegration: false
        },
        icon: path.join(__dirname, '..', 'assets', 'icon.ico'),
        title: "Openworld Launcher",
        autoHideMenuBar: true,
        show: false
    });

    win.loadFile('./src/interface/index.html');

    win.webContents.once('did-finish-load', () => {
        win.show();
        console.log("loaded");
    });

    win.setTitle("Openworld Launcher");

    //win.webContents.openDevTools();
}

ipcMain.on('account-connect', (event, payload) => {
    console.log("yes", payload);

    win.webContents.send('set-state', "Nouvelle version disponible !");

});


app.whenReady().then(createWindow);



